<?php



/**
 * Processes a string to decode URL-encoded symbols 
 * if the '%' character is present.
 */
function decodePercentString($input) {
    // Check if the string contains the '%' symbol
    if (strpos($input, '%') !== false) {
        // urldecode converts sequences like %20 back to " "
        return urldecode($input);
    }
    
    return $input;
}

$url = decodePercentString($url);



// 2. Replace special characters with spaces
// This regex keeps only alphanumeric characters (a-z, A-Z, 0-9)

$cleanString = preg_replace('/[^a-zA-Z0-9]/', ' ', $url);


// 3. Extract words and limit to the first five

$words = array_filter(explode(' ', $cleanString));
 // explode and remove empty strings

$limitedWords = array_slice($words, 0, 20);


// 4. Set up the directory

$directory = 'json_search';

if (!is_dir($directory)) {
    mkdir($directory, 0777, true);

}


// 5. Generate SHA256 hash of the URL

$urlHash = hash('sha256', $url);


// 6. Process each word

foreach ($limitedWords as $word) {
    $filename = $directory . '/' . strtolower($word) . '.json';

    
    // Prepare the data structure

    $data = [
        "title" => $url,
        "filename" => $urlHash
    ];


    // Encode to JSON and add a newline for better readability when appending
    
$jsonContent = json_encode($data) . PHP_EOL;


    // Append to the file (FILE_APPEND prevents overwriting)
    


file_put_contents($filename, $jsonContent, FILE_APPEND | LOCK_EX);

    
    //echo "Processed word: '{$word}' -> Saved to {$filename}\n";

}



?>