﻿<?php
// --- CONFIGURATION & DATA STORAGE ---
$ledgerFile = 'ledger.json';
$historyFile = 'history.json';

// 1. Identity Logic
$userIP = $_SERVER['REMOTE_ADDR'];
$userHash = hash('sha256', $userIP);

// 2. File Initialization
if (!file_exists($ledgerFile)) file_put_contents($ledgerFile, json_encode([]));
if (!file_exists($historyFile)) file_put_contents($historyFile, json_encode([]));

$ledger = json_decode(file_get_contents($ledgerFile), true);
$history = json_decode(file_get_contents($historyFile), true);

// 3. Wallet Creation
if (!isset($ledger[$userHash])) {
    $ledger[$userHash] = ['balance' => 100, 'has_transacted' => false];
    file_put_contents($ledgerFile, json_encode($ledger));
}

// 4. Transaction Logic
$message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['send_to'], $_POST['amount'])) {
    $recipient = trim($_POST['send_to']);
    $amount = (int)$_POST['amount'];

    if ($ledger[$userHash]['has_transacted']) {
        $message = "<div class='error'>Error: Only 1 transaction allowed per IP.</div>";
    } elseif ($amount <= 0 || $ledger[$userHash]['balance'] < $amount) {
        $message = "<div class='error'>Error: Insufficient funds.</div>";
    } elseif (!isset($ledger[$recipient])) {
        $message = "<div class='error'>Error: Recipient not found.</div>";
    } elseif ($recipient === $userHash) {
        $message = "<div class='error'>Error: Cannot send to self.</div>";
    } else {
        // Execute Move
        $ledger[$userHash]['balance'] -= $amount;
        $ledger[$recipient]['balance'] += $amount;
        $ledger[$userHash]['has_transacted'] = true;

        // Log History
        $history[] = [
            'from' => $userHash,
            'to' => $recipient,
            'amount' => $amount,
            'time' => date('Y-m-d H:i:s')
        ];

        file_put_contents($ledgerFile, json_encode($ledger));
        file_put_contents($historyFile, json_encode($history));
        $message = "<div class='success'>Success! Sent $amount HC.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>HashCoin Ledger & History</title>
    <style>
        :root { --primary: #2563eb; --dark: #0f172a; --light: #f1f5f9; }
        body { font-family: system-ui, sans-serif; margin: 0; background: var(--light); color: var(--dark); }
        
        /* Layout */
        header { background: var(--dark); color: white; padding: 1rem 5%; display: flex; justify-content: space-between; align-items: center; position: sticky; top: 0; }
        nav a { color: #cbd5e1; text-decoration: none; margin-left: 20px; font-size: 0.9rem; }
        nav a:hover { color: white; }
        .container { max-width: 900px; margin: 2rem auto; padding: 0 1rem; min-height: 80vh; }
        footer { background: #e2e8f0; text-align: center; padding: 2rem; margin-top: 3rem; font-size: 0.8rem; color: #64748b; }

        /* Cards & UI */
        .card { background: white; padding: 1.5rem; border-radius: 12px; border: 1px solid #e2e8f0; margin-bottom: 1.5rem; }
        .hash-box { background: #f8fafc; border: 1px solid #e2e8f0; padding: 0.5rem; border-radius: 6px; font-family: monospace; font-size: 0.75rem; word-break: break-all; }
        .balance-amt { font-size: 2.5rem; font-weight: 800; color: var(--primary); margin: 0.5rem 0; }
        
        form { display: grid; gap: 1rem; }
        input { padding: 0.75rem; border: 1px solid #cbd5e1; border-radius: 6px; }
        button { background: var(--primary); color: white; border: none; padding: 0.75rem; border-radius: 6px; cursor: pointer; font-weight: 600; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 1rem; font-size: 0.85rem; }
        th, td { text-align: left; padding: 12px; border-bottom: 1px solid #e2e8f0; }
        th { background: #f8fafc; color: #64748b; font-weight: 600; }

        .success { background: #dcfce7; color: #166534; padding: 1rem; border-radius: 8px; margin-bottom: 1rem; }
        .error { background: #fee2e2; color: #991b1b; padding: 1rem; border-radius: 8px; margin-bottom: 1rem; }
    </style>
</head>
<body>

<header>
    <div><strong>HashCoin</strong> <small>Testnet</small></div>
    <nav>
        <a href="#wallet">Wallet</a>
        <a href="#network">Network</a>
        <a href="#history">History</a>
    </nav>
</header>

<div class="container">
    <?php echo $message; ?>

    <div id="wallet" class="card">
        <h3>My Wallet</h3>
        <p>Your Address:</p>
        <div class="hash-box"><?php echo $userHash; ?></div>
        <div class="balance-amt"><?php echo $ledger[$userHash]['balance']; ?> <small>HC</small></div>
        
        <hr style="border:0; border-top:1px solid #eee; margin: 1.5rem 0;">

        <h4>Send Coins</h4>
        <?php if ($ledger[$userHash]['has_transacted']): ?>
            <p style="color: #ef4444; font-weight: 500;">🔒 Transaction limit reached (1/1 per IP).</p>
        <?php else: ?>
            <form method="POST">
                <input type="text" name="send_to" placeholder="Recipient Hash Address" required>
                <input type="number" name="amount" placeholder="Amount (HC)" min="1" required>
                <button type="submit">Confirm One-Time Transfer</button>
            </form>
        <?php endif; ?>
    </div>

    <div id="history" class="card">
        <h3>Transaction History</h3>
        <?php if (empty($history)): ?>
            <p>No transactions recorded yet.</p>
        <?php else: ?>
            <table>
                <thead>
                    <tr><th>Time</th><th>From</th><th>To</th><th>Amount</th></tr>
                </thead>
                <tbody>
                    <?php foreach (array_reverse($history) as $tx): ?>
                    <tr>
                        <td style="white-space:nowrap;"><?php echo $tx['time']; ?></td>
                        <td><div class="hash-box" style="width:100px; overflow:hidden; text-overflow:ellipsis;"><?php echo $tx['from']; ?></div></td>
                        <td><div class="hash-box" style="width:100px; overflow:hidden; text-overflow:ellipsis;"><?php echo $tx['to']; ?></div></td>
                        <td><strong><?php echo $tx['amount']; ?> HC</strong></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>

    <div id="network" class="card">
        <h3>Active Network Wallets</h3>
        <table>
            <thead><tr><th>Address</th><th>Balance</th></tr></thead>
            <tbody>
                <?php foreach ($ledger as $h => $data): ?>
                <tr>
                    <td><div class="hash-box"><?php echo $h; ?></div></td>
                    <td><?php echo $data['balance']; ?> HC</td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<footer>
    PHP Hash-Coin Test Environment<br>
    Identified by: <?php echo $userIP; ?> (Hashed for privacy)
</footer>

</body>
</html>