<?php
// Configuration & Setup
$upload_dir = 'files/';
$ip_dir = 'user_ip/';
$text_dir = 'textarea_hash/';
$message = "";

// Ensure directories exist (manual creation is safer, but this helps)
foreach ([$upload_dir, $ip_dir, $text_dir] as $dir) {
    if (!is_dir($dir)) mkdir($dir, 0755, true);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file_upload'])) {
    $file = $_FILES['file_upload'];
    $user_ip = $_SERVER['REMOTE_ADDR'];
    $ip_hash = hash('sha256', $user_ip);
    $ip_file_path = $ip_dir . $ip_hash;

    // 1. Check if User IP has already uploaded
    if (file_exists($ip_file_path)) {
        $message = "Error: You have already uploaded a file.";
    } else {
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $file_size = $file['size'];

        // 2. Validate Size and Extension
        if ($file_size > 51200) { // 50kb in bytes
            $message = "Error: File is too large (Max 50KB).";
        } elseif ($ext === 'php') {
            $message = "Error: .php files are not allowed.";
        } elseif ($file['error'] !== UPLOAD_ERR_OK) {
            $message = "Error during upload.";
        } else {
            // 3. Generate SHA256 filename
            $file_hash = hash_file('sha256', $file['tmp_name']);
            $new_filename = $file_hash . '.' . $ext;
            $destination = $upload_dir . $new_filename;

            if (move_uploaded_file($file['tmp_name'], $destination)) {
                // 4. Save Payment Info (Textarea)
                $payment_info = $_POST['payment_info'] ?? '';
                file_put_contents($text_dir . $file_hash . '.txt', $payment_info);

                // 5. Mark IP as used
                file_put_contents($ip_file_path, time());

                $message = "Success! File uploaded as: " . $new_filename;
            } else {
                $message = "Error saving file.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Share.</title>
    <style>
        body {
            background-color: #2ecc71; /* Green background */
            font-family: 'Arial', sans-serif;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
            color: white;
        }
        .container {
            text-align: center;
            background: rgba(0,0,0,0.1);
            padding: 2rem;
            border-radius: 15px;
        }
        h1 { font-size: 3rem; margin-bottom: 1rem; }
        .btn-upload {
            background-color: black;
            color: white;
            padding: 10px 30px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1.1rem;
            margin-top: 10px;
        }
        .btn-upload:hover { opacity: 0.8; }
        textarea {
            margin-top: 20px;
            width: 300px;
            height: 100px;
            border-radius: 5px;
            border: none;
            padding: 10px;
        }
        footer {
            margin-top: 50px;
            font-size: 0.9rem;
        }
        footer a { color: black; text-decoration: underline; }
        .msg { margin-bottom: 15px; font-weight: bold; color: #000; }
    </style>
</head>
<body>

    <div class="container">
        <h1>Share.</h1>
        
        <?php if ($message): ?>
            <div class="msg"><?php echo $message; ?></div>
        <?php endif; ?>

        <form action="" method="POST" enctype="multipart/form-data">
            <input type="file" name="file_upload" required><br>
            <button type="submit" class="btn-upload">Upload</button><br>
            
            <textarea name="payment_info" placeholder="Insert payment information here..."></textarea>
        </form>
    </div>

    <footer>
        <p>
            <a href="?download_source=1" target="_blank">Download Sourcecode</a>
        </p>
    </footer>

</body>
</html>

<?php
// Handle Source Code Download
if (isset($_GET['download_source'])) {
    header('Content-Type: text/plain');
    header('Content-Disposition: attachment; filename="source.php"');
    readfile(__FILE__);
    exit;
}
?>