<?php
// 1. Setup - Create necessary directories
$dirs = ['tmp_url', 'tmp_url_ip', 'tmp_url_server'];
foreach ($dirs as $dir) {
    if (!is_dir($dir)) {
        mkdir($dir, 0777, true);
    }
}

$message = "";
$status = "";

// 2. Logic - Handle Input (GET or POST)
$input_url = $_REQUEST['url'] ?? '';
$type = $_REQUEST['type'] ?? ''; // 'file' or 'server'

if (!empty($input_url) && !empty($type)) {
    $url_hash = hash('sha256', $input_url);
    $url_tmp_path = "tmp_url/$url_hash";

    // Check if this URL has been processed before
    if (!file_exists($url_tmp_path)) {
        
        // Check if URL is online
        $headers = @get_headers($input_url);
        if ($headers && strpos($headers[0], '200')) {
            
            $can_write = false;
            $target_file = ($type === 'server') ? 'servers.txt' : 'files.txt';

            if ($type === 'file') {
                $can_write = true;
            } elseif ($type === 'server') {
                $user_ip_hash = hash('sha256', $_SERVER['REMOTE_ADDR']);
                $url_ip = gethostbyname(parse_url($input_url, PHP_URL_HOST));
                $url_ip_hash = hash('sha256', $url_ip);

                // Server-specific IP checks
                if (!file_exists("tmp_url_ip/$user_ip_hash") && !file_exists("tmp_url_server/$url_ip_hash")) {
                    $can_write = true;
                    // Create the IP tracking files
                    touch("tmp_url_ip/$user_ip_hash");
                    touch("tmp_url_server/$url_ip_hash");
                } else {
                    $message = "Server or User IP already registered.";
                    $status = "error";
                }
            }

            if ($can_write) {
                // Check if already exists in the text file
                $current_content = file_exists($target_file) ? file_get_contents($target_file) : '';
                if (strpos($current_content, $input_url) === false) {
                    $handle = fopen($target_file, "a");
                    fwrite($handle, $input_url . PHP_EOL);
                    fclose($handle);
                    
                    // Create the URL hash file to prevent re-processing
                    touch($url_tmp_path);
                    $message = "URL successfully added to $type list.";
                    $status = "success";
                } else {
                    $message = "URL already exists in $target_file.";
                    $status = "error";
                }
            }
        } else {
            $message = "URL is offline or unreachable.";
            $status = "error";
        }
    } else {
        $message = "This URL has already been processed.";
        $status = "error";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>URL Manager</title>
    <style>
        :root {
            --bg: #ffffff;
            --text: #1a1a1a;
            --accent: #000000;
            --gray: #f4f4f4;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background-color: var(--bg);
            color: var(--text);
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }
        .container {
            text-align: center;
            width: 90%;
            max-width: 800px;
        }
        form {
            display: flex;
            gap: 10px;
            justify-content: center;
            margin-bottom: 20px;
        }
        input[type="text"] {
            flex: 1;
            padding: 20px;
            font-size: 1.2rem;
            border: 2px solid var(--accent);
            outline: none;
            border-radius: 0; /* Rectangular */
        }
        select {
            padding: 0 20px;
            font-size: 1rem;
            border: 2px solid var(--accent);
            background: var(--bg);
            cursor: pointer;
            border-radius: 0;
        }
        button {
            padding: 20px 40px;
            font-size: 1.2rem;
            background-color: var(--accent);
            color: white;
            border: none;
            cursor: pointer;
            transition: opacity 0.2s;
            border-radius: 0;
        }
        button:hover {
            opacity: 0.8;
        }
        .message {
            margin-top: 20px;
            font-weight: 500;
            letter-spacing: -0.5px;
        }
        .success { color: #2ecc71; }
        .error { color: #e74c3c; }
    </style>
</head>
<body>

<div class="container">
    <form method="POST">
        <input type="text" name="url" placeholder="Enter URL (https://...)" required>
        <select name="type">
            <option value="file">File</option>
            <option value="server">Server</option>
        </select>
        <button type="submit">Submit</button>
    </form>

    <?php if ($message): ?>
        <div class="message <?php echo $status; ?>">
            <?php echo htmlspecialchars($message); ?>
        </div>
    <?php endif; ?>
</div>

</body>
</html>