<?php
session_start();

// Configuration
$salt = "YOUR_UNIQUE_SALT_HERE"; // Change this for security
$max_size = 200 * 1024 * 1024; // 200MB in bytes
$directories = ['rizoma', 'files', 'file_hash', 'url_hash'];

// 1. Create directories if they don't exist
foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
}

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['urls'])) {
    $lines = explode("\n", str_replace("\r", "", $_POST['urls']));
    $user_ip = $_SERVER['REMOTE_ADDR'];
    $ip_hash = hash('sha256', $user_ip . $salt);

    foreach ($lines as $url) {
        $url = trim($url);
        if (empty($url)) continue;

        // 2. Check if URL hash already exists
        $url_hash = hash('sha256', $url);
        $url_hash_path = "url_hash/" . $url_hash;
        
        if (file_exists($url_hash_path)) {
            continue; // Skip if processed before
        }

        // 3. Validate URL and check if online
        if (filter_var($url, FILTER_VALIDATE_URL)) {
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_NOBODY, false); 
            curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            
            $content = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $content_size = curl_getinfo($ch, CURLINFO_CONTENT_LENGTH_DOWNLOAD);
            
            if ($http_code == 200 && $content !== false) {
                
                // 4. Save content to "rizoma" folder (IP Hash filename)
                // Note: This will overwrite for each line if multiple URLs are processed
                file_put_contents("rizoma/$ip_hash.txt", $_POST['urls']);

                // 5. Check if file is smaller than 200MB
                if ($content_size > 0 && $content_size < $max_size) {
                    $file_content_hash = hash('sha256', $content);
                    $ext = pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION);
                    $ext = $ext ? ".$ext" : "";
                    
                    $file_path = "files/" . $file_content_hash . $ext;
                    
                    // Save to "files" if not exists
                    if (!file_exists($file_path)) {
                        file_put_contents($file_path, $content);
                    }

                    // 6. Save session user to "file_hash"
                    $file_hash_path = "file_hash/" . $file_content_hash;
                    if (!file_exists($file_hash_path)) {
                        $user_data = isset($_SESSION['user']) ? $_SESSION['user'] : "unknown_user";
                        file_put_contents($file_hash_path, $user_data);
                    }
                }

                // 7. Mark URL as processed in "url_hash"
                file_put_contents($url_hash_path, $url);
            }
            curl_close($ch);
        }
    }
    $message = "Processing complete.";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>URL Processor</title>
    <style>
        body { font-family: sans-serif; margin: 20px; }
        textarea { width: 100%; height: 150px; margin-bottom: 10px; }
        .status { color: green; font-weight: bold; }
    </style>
</head>
<body>
    <h2>Bulk URL Downloader and Share</h2>
    <?php if ($message) echo "<p class='status'>$message</p>"; ?>
    <form method="post">
        <label>Enter URLs (one per line):</label><br>
        <textarea name="urls" placeholder="https://example.com/file.jpg"></textarea><br>
        <button type="submit">Process URLs</button>
    </form>
</body>
</html>