﻿<?php
// Configuration
$baseDir = 'rhyzom';
$tmpDir = 'tmp_rhyzom';
$message = "";
$currentView = $_GET['view'] ?? 'landing';

// Helper: Securely get folder list
function getCategories($path) {
    if (!is_dir($path)) return [];
    return array_filter(scandir($path), function($item) use ($path) {
        return is_dir($path . '/' . $item) && !in_array($item, ['.', '..']);
    });
}

// --- Processing Logic: File Writing ---
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['signature'])) {
    $currentView = 'app';
    $categories = [];
    if (isset($_POST['categories']) && is_array($_POST['categories'])) {
        foreach (array_slice($_POST['categories'], 0, 5) as $cat) {
            $cat = trim($cat);
            if (preg_match('/^[a-zA-Z0-9_]{1,12}$/', $cat) && !empty($cat)) {
                $categories[] = $cat;
            }
        }
    }

    $signature = substr(trim($_POST['signature'] ?? ''), 0, 50);
    $fileHash = hash('sha256', $signature);
    $contentRaw = $_POST['content'] ?? '';
    $lines = explode("\n", str_replace("\r", "", $contentRaw));
    $metadata = $lines[0] ?? '';
    $validUrls = [];

    for ($i = 1; $i < count($lines); $i++) {
        $url = trim($lines[$i]);
        if (!empty($url) && filter_var($url, FILTER_VALIDATE_URL)) {
            $validUrls[] = $url;
        }
    }

    if (!empty($categories) && !empty($signature)) {
        $fileData = "Metadata: " . $metadata . "\nURLs:\n" . implode("\n", $validUrls);
        foreach ($categories as $folderName) {
            $targetFolder = $baseDir . DIRECTORY_SEPARATOR . $folderName;
            if (!is_dir($targetFolder)) mkdir($targetFolder, 0755, true);
            $handle = fopen($targetFolder . DIRECTORY_SEPARATOR . $fileHash, "w");
            if ($handle) { fwrite($handle, $fileData); fclose($handle); }
        }
        $message = "Success: Data distributed.";
    }
}

// --- Tracking & Reading Logic ---
$fileContent = "";
if ($currentView === 'read' && isset($_GET['cat']) && isset($_GET['file'])) {
    $safeCat = basename($_GET['cat']);
    $safeFile = basename($_GET['file']);
    $targetPath = $baseDir . "/$safeCat/$safeFile";

    if (file_exists($targetPath)) {
        $fileContent = file_get_contents($targetPath);
        
        // Access Tracking Logic
        $userIpHash = hash('sha256', $_SERVER['REMOTE_ADDR']);
        $trackFolder = $tmpDir . DIRECTORY_SEPARATOR . $safeFile;
        
        if (!is_dir($trackFolder)) mkdir($trackFolder, 0755, true);
        
        // Write empty file with IP hash as name to count unique access
        $trackHandle = fopen($trackFolder . DIRECTORY_SEPARATOR . $userIpHash, "w");
        if ($trackHandle) fclose($trackHandle);
    } else {
        $message = "Error: File not found.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Rhyzom | Data Explorer</title>
    <style>
        :root { --primary: #2563eb; --bg: #f8fafc; --text: #334155; }
        body { font-family: sans-serif; background: var(--bg); color: var(--text); margin: 0; padding-bottom: 50px; }
        .nav { background: #fff; padding: 1rem 2rem; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .container { max-width: 900px; margin: 2rem auto; padding: 0 1rem; }
        .card { background: #fff; padding: 2rem; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
        .btn { padding: 0.6rem 1.2rem; border-radius: 6px; text-decoration: none; cursor: pointer; border: none; font-weight: 600; display: inline-block; }
        .btn-primary { background: var(--primary); color: #fff; }
        .grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 1rem; }
        .item-link { display: block; padding: 1rem; background: #f1f5f9; border-radius: 8px; text-decoration: none; color: var(--text); font-weight: 500; border: 1px solid #e2e8f0; }
        .item-link:hover { background: #e2e8f0; }
        pre { background: #1e293b; color: #f8fafc; padding: 1.5rem; border-radius: 8px; overflow-x: auto; white-space: pre-wrap; }
        .msg { padding: 1rem; margin-bottom: 1rem; border-radius: 6px; }
        .error { background: #fee2e2; color: #991b1b; }
        .success { background: #dcfce7; color: #166534; }
    </style>
</head>
<body>

<nav class="nav">
    <a href="?view=landing" style="font-weight:800; color:var(--primary); text-decoration:none;">RHYZOM</a>
    <div>
        <a href="?view=browse" class="btn" style="color:var(--text)">Browse</a>
        <a href="?view=app" class="btn btn-primary">Add New</a>
    </div>
</nav>

<div class="container">
    <?php if ($message): ?>
        <div class="msg <?php echo strpos($message, 'Error') === 0 ? 'error' : 'success'; ?>"><?php echo $message; ?></div>
    <?php endif; ?>

    <?php if ($currentView === 'landing'): ?>
        <div style="text-align:center; padding: 4rem 0;">
            <h1>Knowledge Fragmentation System</h1>
            <p>Organize resources, hash your identity, and track unique reach.</p>
            <a href="?view=browse" class="btn btn-primary">Start Browsing</a>
        </div>

    <?php elseif ($currentView === 'browse'): ?>
        <div class="card">
            <h2>Categories</h2>
            <div class="grid">
                <?php 
                $cats = getCategories($baseDir);
                foreach ($cats as $c): ?>
                    <a href="?view=list&cat=<?php echo urlencode($c); ?>" class="item-link">📁 <?php echo htmlspecialchars($c); ?></a>
                <?php endforeach; ?>
                <?php if (empty($cats)) echo "<p>No categories found yet.</p>"; ?>
            </div>
        </div>

    <?php elseif ($currentView === 'list'): ?>
        <div class="card">
            <h2>Files in: <?php echo htmlspecialchars($_GET['cat']); ?></h2>
            <div class="grid">
                <?php 
                $safeCat = basename($_GET['cat']);
                $files = array_diff(scandir($baseDir."/".$safeCat), ['.', '..']);
                foreach ($files as $f): ?>
                    <a href="?view=read&cat=<?php echo urlencode($safeCat); ?>&file=<?php echo urlencode($f); ?>" class="item-link">📄 <?php echo substr($f, 0, 15); ?>...</a>
                <?php endforeach; ?>
            </div>
            <br><a href="?view=browse">&larr; Back to Categories</a>
        </div>

    <?php elseif ($currentView === 'read'): ?>
        <div class="card">
            <h2>File Content</h2>
            <small>Filename (SHA-256): <?php echo htmlspecialchars($_GET['file']); ?></small>
            <pre><?php echo htmlspecialchars($fileContent); ?></pre>
            
            <hr>
            <?php
                $trackPath = $tmpDir . '/' . basename($_GET['file']);
                $views = is_dir($trackPath) ? count(array_diff(scandir($trackPath), ['.', '..'])) : 0;
            ?>
            <p><strong>Unique IP Accesses:</strong> <?php echo $views; ?></p>
            <a href="?view=list&cat=<?php echo urlencode($_GET['cat']); ?>" class="btn btn-primary">Back to List</a>
        </div>

    <?php elseif ($currentView === 'app'): ?>
        <div class="card">
            <h2>Distribute Data</h2>
            <form method="POST">
                <input type="text" name="categories[]" placeholder="Category Name" maxlength="12" style="width:100%; margin-bottom:10px; padding:10px;">
                <textarea name="content" placeholder="Line 1: Metadata&#10;Line 2: URL" style="width:100%; height:100px; margin-bottom:10px; padding:10px;"></textarea>
                <input type="text" name="signature" placeholder="Signature (Max 50)" maxlength="50" style="width:100%; margin-bottom:10px; padding:10px;" required>
                <button type="submit" class="btn btn-primary" style="width:100%;">Save & Hash</button>
            </form>
        </div>
    <?php endif; ?>
</div>

</body>
</html>