<?php
// 1. Setup - Create the storage directory if it doesn't exist
$directory = 'files';
if (!is_dir($directory)) {
    mkdir($directory, 0777, true);
}

$message = "";
$status = "";

// 2. Logic - Handle Content Submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['content'])) {
    $content = $_POST['content'];
    
    // Generate filename: SHA256(IP + YYYY-MM-DD)
    $salt = date('Y-m-d');
    $user_ip = $_SERVER['REMOTE_ADDR'];
    $filename = hash('sha256', $user_ip . $salt) . ".txt";
    $filepath = $directory . '/' . $filename;

    // Overwrite the file using fopen
    $handle = fopen($filepath, "w");
    if ($handle) {
        fwrite($handle, $content);
        fclose($handle);
        $message = "File saved successfully as: " . "<a href='files/$filename'>$filename</a>";
        $status = "success";
    } else {
        $message = "Error: Could not write to file.";
        $status = "error";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Minimalist Paste</title>
    <style>
        :root {
            --bg: #ffffff;
            --text: #000000;
            --border: #000000;
        }
        body {
            font-family: ui-monospace, 'Cascadia Code', 'Source Code Pro', Menlo, monospace;
            background-color: var(--bg);
            color: var(--text);
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }
        .container {
            width: 90%;
            max-width: 900px;
            text-align: center;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 0; /* Brutalist stack */
        }
        textarea {
            width: 100%;
            height: 400px;
            padding: 20px;
            font-size: 1.1rem;
            border: 3px solid var(--border);
            box-sizing: border-box;
            outline: none;
            resize: none;
            border-bottom: none; /* Connect to button */
        }
        button {
            width: 100%;
            padding: 25px;
            font-size: 1.5rem;
            font-weight: bold;
            background-color: var(--border);
            color: white;
            border: 3px solid var(--border);
            cursor: pointer;
            text-transform: uppercase;
            transition: background 0.2s;
        }
        button:hover {
            background-color: #333;
        }
        .message {
            margin-top: 20px;
            padding: 15px;
            font-size: 0.9rem;
            word-break: break-all;
        }
        .success { background: #e8f5e9; color: #2e7d32; }
        .error { background: #ffebee; color: #c62828; }
    </style>
</head>
<body>

<div class="container">
    <form method="POST">
        <textarea name="content" placeholder="Paste your content here..."></textarea>
        <button type="submit">SAVE CONTENT</button>
    </form>

    <?php if ($message): ?>
        <div class="message <?php echo $status; ?>">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>
</div>

</body>
</html>