<?php
// 1. CONFIGURATION & DIRECTORY SETUP
$dirs = ['files', 'thumb', 'ip', 'likes'];
foreach ($dirs as $dir) {
    if (!is_dir($dir)) mkdir($dir, 0777, true);
}

$user_ip_hash = hash('sha256', $_SERVER['REMOTE_ADDR']);
$message = "";

// 2. HANDLE LIKE ACTION
if (isset($_GET['like'])) {
    $image_name = basename($_GET['like']); // Security: basename prevents directory traversal
    $like_folder = "likes/" . $image_name;
    if (!is_dir($like_folder)) mkdir($like_folder, 0777, true);
    
    $ip_file = $like_folder . "/" . $user_ip_hash;
    file_put_contents($ip_file, "");
    header("Location: " . $_SERVER['PHP_SELF']); // Refresh to clear GET param
    exit;
}

// 3. HANDLE FILE UPLOAD
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['image'])) {
    $file = $_FILES['image'];
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    
    // Validations
    $is_image = getimagesize($file['tmp_name']);
    $under_size = $file['size'] <= 500 * 1024; // 500kb
    $already_uploaded_ip = file_exists("ip/$user_ip_hash");

    if (!$is_image) {
        $message = "Error: File is not an image.";
    } elseif (!$under_size) {
        $message = "Error: File exceeds 500kb.";
    } elseif ($already_uploaded_ip) {
        $message = "Error: You have already uploaded a file.";
    } else {
        $file_hash = hash_file('sha256', $file['tmp_name']);
        $new_filename = $file_hash . "." . $ext;
        $target_path = "files/" . $new_filename;

        if (!file_exists($target_path)) {
            // Move original
            move_uploaded_file($file['tmp_name'], $target_path);
            
            // Create Thumbnail (< 30kb)
            create_thumbnail($target_path, "thumb/" . $new_filename, $ext);
            
            // Log IP
            file_put_contents("ip/$user_ip_hash", "");
            $message = "Upload successful!";
        } else {
            $message = "Error: Image already exists.";
        }
    }
}

// Helper: Image Compression
function create_thumbnail($src, $dest, $ext) {
    list($w, $h) = getimagesize($src);
    $img = ($ext == 'png') ? imagecreatefrompng($src) : imagecreatefromjpeg($src);
    
    // Attempt to compress until under 30KB
    $quality = 80;
    do {
        ob_start();
        imagejpeg($img, null, $quality);
        $data = ob_get_clean();
        $quality -= 5;
    } while (strlen($data) > 30 * 1024 && $quality > 5);
    
    file_put_contents($dest, $data);
    imagedestroy($img);
}

// 4. GET 10 RANDOM IMAGES
$all_thumbs = glob("thumb/*.{jpg,jpeg,png,gif}", GLOB_BRACE);
$random_thumbs = [];
if (!empty($all_thumbs)) {
    $count = min(10, count($all_thumbs));
    $keys = array_rand($all_thumbs, $count);
    if (is_array($keys)) {
        foreach ($keys as $k) $random_thumbs[] = $all_thumbs[$k];
    } else {
        $random_thumbs[] = $all_thumbs[$keys];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TH Token Sharing</title>
    <style>
        body { background-color: #000; color: #fff; font-family: sans-serif; margin: 0; padding: 0; }
        .header { padding: 20px; text-align: center; }
        .upload-sect { text-align: center; padding: 20px; background: #111; }
        
        .gallery-item { 
            position: relative; 
            width: 100%; 
            margin-bottom: 20px; 
            overflow: hidden; 
        }
        .gallery-item img { 
            width: 100%; 
            display: block; 
            cursor: pointer;
        }
        .like-btn {
            position: absolute;
            bottom: 20px;
            right: 20px;
            background: #ff4757;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            font-weight: bold;
        }
        .like-btn:hover { background: #ff6b81; }
        .msg { color: #ffa500; margin-bottom: 10px; }
    </style>
</head>
<body>

    <div class="header">
        <h1>sharing images generated by AI</h1>
    </div>

    <div class="upload-sect">
        <?php if ($message) echo "<p class='msg'>$message</p>"; ?>
        <form action="" method="POST" enctype="multipart/form-data">
            <input type="file" name="image" required>
            <button type="submit">Upload Image</button>
        </form>
    </div>

    <div class="gallery">
        <?php foreach ($random_thumbs as $thumb): 
            $filename = basename($thumb);
            $original = "files/" . $filename;
        ?>
            <div class="gallery-item">
                <a href="<?php echo $original; ?>" target="_blank">
                    <img src="<?php echo $thumb; ?>" alt="Shared Image">
                </a>
                <a href="?like=<?php echo $filename; ?>" class="like-btn">Like</a>
            </div>
        <?php endforeach; ?>
    </div>

</body>
</html>