<?php
// Configuration
$mainFile = 'links.txt';
$archiveDir = 'links';
$maxSize = 100 * 1024; // 100KB in bytes

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['urls'])) {
    $urls = trim($_POST['urls']) . PHP_EOL;
    $targetFile = $mainFile;

    // 1. Determine the target file based on size
    if (file_exists($mainFile) && filesize($mainFile) > $maxSize) {
        // Create the directory if it doesn't exist
        if (!is_dir($archiveDir)) {
            mkdir($archiveDir, 0777, true);
        }
        $targetFile = $archiveDir . DIRECTORY_PATH_SEPARATOR . date('Y-m-d') . '.txt';
    }

    // 2. Save the file with a lock to avoid race conditions
    // 'a' flag opens for writing only; place file pointer at the end of the file.
    $fp = fopen($targetFile, 'a');

    if ($fp) {
        // Acquire an exclusive lock (LOCK_EX)
        if (flock($fp, LOCK_EX)) {
            fwrite($fp, $urls);
            fflush($fp);            // Flush output before releasing the lock
            flock($fp, LOCK_UN);    // Release the lock
            $message = "Successfully saved to: " . htmlspecialchars($targetFile);
        } else {
            $message = "Error: Could not lock the file for writing.";
        }
        fclose($fp);
    } else {
        $message = "Error: Could not open the file.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>URL List Saver</title>
    <style>
        body { font-family: sans-serif; max-width: 600px; margin: 40px auto; line-height: 1.6; }
        textarea { width: 100%; height: 200px; margin-bottom: 10px; }
        .status { padding: 10px; background: #e7f3ff; border: 1px solid #b2d7ff; margin-bottom: 20px; }
        button { padding: 10px 20px; cursor: pointer; }
    </style>
</head>
<body>

    <h2>Paste URL List</h2>
    
    <?php if ($message): ?>
        <div class="status"><?php echo $message; ?></div>
    <?php endif; ?>

    <form method="POST">
        <textarea name="urls" placeholder="Enter one URL per line..."></textarea><br>
        <button type="submit">Save URLs</button>
    </form>

</body>
</html>