<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rhyzom | Decentralized Data Portal</title>
    <style>
        :root {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --bg: #f8fafc;
            --card-bg: #ffffff;
            --text-main: #1e293b;
            --text-muted: #64748b;
            --border: #e2e8f0;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background-color: var(--bg);
            color: var(--text-main);
            margin: 0;
            line-height: 1.6;
        }

        /* Navigation */
        .navbar {
            background: #ffffff;
            border-bottom: 1px solid var(--border);
            padding: 1rem 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .logo {
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--primary);
            text-decoration: none;
            letter-spacing: -1px;
        }

        .nav-links {
            display: flex;
            gap: 1.5rem;
        }

        .nav-links a {
            text-decoration: none;
            color: var(--text-muted);
            font-weight: 500;
            font-size: 0.95rem;
            transition: color 0.2s;
        }

        .nav-links a:hover {
            color: var(--primary);
        }

        /* Hero Section */
        .container {
            max-width: 1100px;
            margin: 0 auto;
            padding: 4rem 1.5rem;
        }

        .hero {
            text-align: center;
            margin-bottom: 5rem;
        }

        .hero h1 {
            font-size: 3.5rem;
            font-weight: 900;
            margin-bottom: 1.5rem;
            color: #0f172a;
            letter-spacing: -0.025em;
        }

        .hero p {
            font-size: 1.25rem;
            color: var(--text-muted);
            max-width: 700px;
            margin: 0 auto 2rem;
        }

        /* Portal Grid */
        .portal-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 1.5rem;
            margin-top: 2rem;
        }

        .portal-card {
            background: var(--card-bg);
            border: 1px solid var(--border);
            border-radius: 16px;
            padding: 2rem;
            text-decoration: none;
            color: inherit;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }

        .portal-card:hover {
            transform: translateY(-5px);
            border-color: var(--primary);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.05);
        }

        .portal-card h3 {
            margin: 0;
            font-size: 1.25rem;
            color: #0f172a;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .portal-card p {
            margin: 0;
            color: var(--text-muted);
            font-size: 0.95rem;
        }

        .icon {
            width: 32px;
            height: 32px;
            background: #eef2ff;
            color: var(--primary);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }

        /* Footer */
        footer {
            text-align: center;
            padding: 4rem 0;
            border-top: 1px solid var(--border);
            color: var(--text-muted);
            font-size: 0.9rem;
            margin-top: 4rem;
        }

        @media (max-width: 768px) {
            .hero h1 { font-size: 2.5rem; }
            .nav-links { display: none; }
        }
    </style>
</head>
<body>

    <nav class="navbar">
        <a href="#" class="logo">RHYZOM</a>
        <div class="nav-links">
            <a href="index.php">Home</a>
            <a href="paste.php">Paste</a>
        </div>
    </nav>

    <div class="container">
        <section class="hero">
            <h1>The Decentralized Information Layer</h1>
            <p>Rhyzom is a minimalist ecosystem designed for data management and organized digital assets.</p>
            <div style="display: flex; gap: 1rem; justify-content: center;">
                <a href="#" style="background: var(--primary); color: white; padding: 0.8rem 2rem; border-radius: 8px; text-decoration: none; font-weight: 600;">Sourcecode</a>
                <a href="README.html" style="background: white; border: 1px solid var(--border); color: var(--text-main); padding: 0.8rem 2rem; border-radius: 8px; text-decoration: none; font-weight: 600;">Learn More</a>
            </div>
        </section>

        <div class="portal-grid">
            <a href="paste.php" class="portal-card">
                <h3><span class="icon">P</span> Paste</h3>
                <p>Quick, temporary text snippets for easy sharing and code blocks.</p>
            </a>

            <a href="message.php" class="portal-card">
                <h3><span class="icon">M</span> Messages</h3>
                <p>Private communication channels and groups. </p>
            </a>

            <a href="rhyzom.php" class="portal-card">
                <h3><span class="icon">A</span> Links</h3>
                <p>Share a list of links to files (eg: https://test.com/1.jpg). You can add some metadata or description in the first line of text.</p>
            </a>

            <a href="blocks.php" class="portal-card">
                <h3><span class="icon">B</span> Blocks</h3>
                <p>Manage immutable metadata content storage.</p>
            </a>

            <a href="vault.php" class="portal-card">
                <h3><span class="icon">V</span> Vault</h3>
                <p>Send pictures or text files and save ordered (eg: 1.txt, 2.txt, 3.txt ...)</p>
            </a>

            <a href="index_simple.php" class="portal-card">
                <h3><span class="icon">G</span> Propagation</h3>
                <p>Send link to servers using GET method.</p>
            </a>

            <a href="search.php" class="portal-card">
                <h3><span class="icon">S</span> Search</h3>
                <p>Discover content using JSON category tags.</p>
            </a>

            <a href="upload.php" class="portal-card">
                <h3><span class="icon">U</span> Upload</h3>
                <p>Upload files.</p>
            </a>

            <a href="main/" class="portal-card">
                <h3><span class="icon">A</span> More</h3>
                <p>Additional and experimental features in the "main" folder.</p>
            </a>
        </div>
    </div>

    <footer>
        &copy; 2026 Rhyzom Protocol. All rights reserved.
    </footer>

</body>
</html>